<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ############################### start display options ###############################
if ($_POST['action'] == 'regionpreview')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'region' 			=> TYPE_ARRAY,
		'signaturestyleid' 	=> TYPE_UINT,
	));
	
	if (is_array($vbulletin->GPC['region']['title']))
	{
		$regions = array();
		foreach ($vbulletin->GPC['region'] as $key => $vals)
		{
			foreach ($vals as $key2 => $val)
			{
				$regions[$key2][$key] = $val;
			}
		}
		
		// Create composite preview image
		VBSIGNATURES::createImage(array(), $regions, 'textregion_preview', $vbulletin->GPC['signaturestyleid']);
	}
	else
	{
		// Create the new preview image
		VBSIGNATURES::previewText($vbulletin->GPC['region'], $vbulletin->GPC['signaturestyleid']);
	}

	header('Content-type: application/json');
	echo VBSIGNATURES::encodeJSON(array(
		'img' => $vbulletin->options['bburl'] . '/dbtech/vbsignatures/images/signatures/textregion_preview.png'
	));
	die();
}

// ############################### start display options ###############################
if ($_POST['action'] == 'setsignature')
{
	$signaturestyleid = $vbulletin->input->clean_gpc('p', 'signaturestyleid', TYPE_UINT);
	
	if (!$vbulletin->userinfo['userid'])
	{
		// Always null this out
		echo VBSIGNATURES::encodeJSON(array(
			'error' => 'noguest',
		));
		die();	
	}
	
	if (!$signaturestyle = VBSIGNATURES::$cache['signaturestyle'][$signaturestyleid])
	{
		// Always null this out
		echo VBSIGNATURES::encodeJSON(array(
			'error' => 'wrongstyle',
		));
		die();	
	}
	
	if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $signaturestyle['permissions'], 'default'))
	{
		// This item isn't to be displayed
		echo VBSIGNATURES::encodeJSON(array(
			'error' => 'wrongstyle',
		));
		die();	
	}
	
	// Take away points
	VBSIGNATURES::$db->update('user', array(
		'dbtech_vbsignatures_signature' => $signaturestyleid
	), 'WHERE userid = ' . intval($vbulletin->userinfo['userid']));
	
	echo VBSIGNATURES::encodeJSON(array(
		'dosave' => true
	));
	die();	
}

// ############################### start display options ###############################
if ($_POST['action'] == 'updatepreview')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'signaturestyleid' 	=> TYPE_UINT,
		'parts' 			=> TYPE_ARRAY,
		'usepreview' 		=> TYPE_BOOL,
		'region' 			=> TYPE_ARRAY,
		'font' 				=> TYPE_ARRAY,
	));
	
	if (!$vbulletin->userinfo['userid'])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'noguest',
		));
		die();	
	}
	
	if (!$signaturestyle = VBSIGNATURES::$cache['signaturestyle'][$vbulletin->GPC['signaturestyleid']])
	{
		// Always null this out
		echo VBSIGNATURES::encodeJSON(array(
			'error' => 'wrongstyle',
		));
		die();	
	}
	
	if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $signaturestyle['permissions'], 'default'))
	{
		// This item isn't to be displayed
		echo VBSIGNATURES::encodeJSON(array(
			'error' => 'wrongstyle',
		));
		die();	
	}
	
	// Grab our inventory
	$inventory = VBSIGNATURES::$db->fetchAllSingleKeyed('SELECT * FROM $dbtech_vbsignatures_inventory WHERE userid = ?', 'partid', 'userid', array($vbulletin->userinfo['userid']));	
	
	$hasBase = false;
	foreach ((array)$vbulletin->GPC['parts'] as $folder => $partid)
	{
		if (!$part = VBSIGNATURES::$cache['part'][$partid])
		{
			// Part didn't exist
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		if (!$part['active'])
		{
			// Inactive type
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		if ($part['signaturestyleid'] != $signaturestyle['signaturestyleid'])
		{
			// Always null this out
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}		
		
		if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $part['permissions'], 'default'))
		{
			// This item isn't to be displayed
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, VBSIGNATURES::$cache['category'][$part['categoryid']]['permissions'], 'default'))
		{
			// This category isn't to be displayed
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		/*
		if ($part['price'] > 0 AND !$inventory[$partid])
		{
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		*/
		
		if ($folder)
		{
			// Not base
			continue;
		}
		
		// We have base!
		$hasBase = true;
	}
	
	$regions = array();
	if ($hasBase)
	{
		foreach ((array)VBSIGNATURES::$cache['region'] as $regionid => $region)
		{
			if (!$region['active'])
			{
				// Skip this region
				continue;
			}
			
			if ($region['signaturestyleid'] != $signaturestyle['signaturestyleid'])
			{
				// Skip this region
				continue;
			}
			
			if ($vbulletin->GPC['region'][$regionid])
			{
				// Override regiontext
				$region['regiontext'] = $vbulletin->GPC['region'][$regionid];
			}
			
			if ($vbulletin->GPC['font'][$regionid])
			{
				do
				{
					if (!$font = VBSIGNATURES::$cache['font'][$vbulletin->GPC['font'][$regionid]])
					{
						// Font doesn't exist
						break;
					}
					
					if (!$font['active'])
					{
						// Inactive font
						break;
					}
					
					if (!$font['cancustom'])
					{
						// Can't be used in custom stuff
						break;
					}
					
					// Override regiontext
					$region['fontid'] = $vbulletin->GPC['font'][$regionid];				
				}
				while (false);
			}
			
			// Default info
			$regions[$regionid] = $region;
		}
	}
	
	// Create the new preview image
	VBSIGNATURES::createImage($vbulletin->GPC['parts'], $regions, $vbulletin->userinfo['userid'] . '_' . $signaturestyle['signaturestyleid'] . '_preview');
	
	echo VBSIGNATURES::encodeJSON(array(
		'preview' => true,
	));
	die();	
}

// ############################### start display options ###############################
if ($_POST['action'] == 'savesignature')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'signaturestyleid' 	=> TYPE_UINT,
		'parts' 			=> TYPE_ARRAY,
		'region' 			=> TYPE_ARRAY,
		'font' 				=> TYPE_ARRAY,
	));
	
	if (!$vbulletin->userinfo['userid'])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'noguest',
		));
		die();	
	}
	
	if (!$signaturestyle = VBSIGNATURES::$cache['signaturestyle'][$vbulletin->GPC['signaturestyleid']])
	{
		// Always null this out
		echo VBSIGNATURES::encodeJSON(array(
			'error' => 'wrongstyle',
		));
		die();	
	}
	
	if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $signaturestyle['permissions'], 'default'))
	{
		// This item isn't to be displayed
		echo VBSIGNATURES::encodeJSON(array(
			'error' => 'wrongstyle',
		));
		die();	
	}
	
	// Grab our inventory
	$inventory = VBSIGNATURES::$db->fetchAllSingleKeyed('SELECT * FROM $dbtech_vbsignatures_inventory WHERE userid = ?', 'partid', 'userid', array($vbulletin->userinfo['userid']));	
	
	foreach ((array)$vbulletin->GPC['parts'] as $folder => $partid)
	{
		if (!$part = VBSIGNATURES::$cache['part'][$partid])
		{
			// Part didn't exist
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		if (!$part['active'])
		{
			// Inactive type
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		if ($part['signaturestyleid'] != $signaturestyle['signaturestyleid'])
		{
			// Always null this out
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}		
		
		if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $part['permissions'], 'default'))
		{
			// This item isn't to be displayed
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, VBSIGNATURES::$cache['category'][$part['categoryid']]['permissions'], 'default'))
		{
			// This category isn't to be displayed
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
		
		if ($part['price'] > 0 AND !$inventory[$partid])
		{
			unset($vbulletin->GPC['parts'][$folder]);
			continue;
		}
	}
	
	if (!$vbulletin->GPC['parts'][0])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'nobase',
		));
		die();	
	}
	
	$regions = $regions_save = $fonts_save = array();
	foreach ((array)VBSIGNATURES::$cache['region'] as $regionid => $region)
	{
		if (!$region['active'])
		{
			// Skip this region
			continue;
		}
		
		if ($region['signaturestyleid'] != $signaturestyle['signaturestyleid'])
		{
			// Always null this out
			continue;
		}	
		
		if ($vbulletin->GPC['region'][$regionid])
		{
			// Override regiontext
			$region['regiontext'] = $regions_save[$regionid] = $vbulletin->GPC['region'][$regionid];
		}
		
		if ($vbulletin->GPC['font'][$regionid])
		{
			do
			{
				if (!$font = VBSIGNATURES::$cache['font'][$vbulletin->GPC['font'][$regionid]])
				{
					// Font doesn't exist
					break;
				}
				
				if (!$font['active'])
				{
					// Inactive font
					break;
				}
				
				if (!$font['cancustom'])
				{
					// Can't be used in custom stuff
					break;
				}
				
				// Override regiontext
				$region['fontid'] = $fonts_save[$regionid] = $vbulletin->GPC['font'][$regionid];				
			}
			while (false);
		}
		
		// Default info
		$regions[$regionid] = $region;
	}
	
	// Replace the configuration for this style
	$vbulletin->userinfo['dbtech_vbsignatures_configuration'][$signaturestyle['signaturestyleid']] = array('parts' => $vbulletin->GPC['parts'], 'regions' => $regions_save, 'fonts' => $fonts_save);
		
	// Update configuration
	VBSIGNATURES::$db->update('user', array(
		'dbtech_vbsignatures_configuration' => trim(serialize($vbulletin->userinfo['dbtech_vbsignatures_configuration'])),
		'dbtech_vbsignatures_dateline' 	=> TIMENOW
	), 'WHERE userid = ' . intval($vbulletin->userinfo['userid']));
	
	// Create the new preview image
	VBSIGNATURES::createImage($vbulletin->GPC['parts'], $regions, $vbulletin->userinfo['userid'] . '_' . $signaturestyle['signaturestyleid']);
	
	if ($vbulletin->userinfo['dbtech_vbsignatures_signature'])
	{
		// begin custom signature code
		require_once(DIR . '/includes/class_upload.php');
		require_once(DIR . '/includes/class_image.php');

		$upload = new vB_Upload_Userpic($vbulletin);

		$upload->data =& datamanager_init('Userpic_Sigpic', $vbulletin, ERRTYPE_STANDARD, 'userpic');
		$upload->image =& vB_Image::fetch_library($vbulletin);
		$upload->maxwidth = $vbulletin->userinfo['permissions']['sigpicmaxwidth'];
		$upload->maxheight = $vbulletin->userinfo['permissions']['sigpicmaxheight'];
		$upload->maxuploadsize = $vbulletin->userinfo['permissions']['sigpicmaxsize'];
		$upload->allowanimation = ($vbulletin->userinfo['permissions']['signaturepermissions'] & $vbulletin->bf_ugp_signaturepermissions['cananimatesigpic']) ? true : false;

		if (!$upload->process_upload($vbulletin->options['bburl'] . '/dbtech/vbsignatures/images/signatures/' . $vbulletin->userinfo['userid'] . '_' . $signaturestyle['signaturestyleid'] . '.png'))
		{
			eval(standard_error($upload->fetch_error()));
		}
	}
	
	echo VBSIGNATURES::encodeJSON(array(
		'preview' => false,
		'imgpath' => '[IMG]' . $vbulletin->options['bburl'] . '/dbtech/vbsignatures/images/signatures/' . $vbulletin->userinfo['userid'] . '_' . $signaturestyle['signaturestyleid'] . '.png?d=' . TIMENOW . '[/IMG]'
	));
	die();
}

// ############################### start display options ###############################
if ($_POST['action'] == 'purchase')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'partid' 	=> TYPE_UINT,
	));
	
	if (!$vbulletin->userinfo['userid'])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'noguest',
		));
		die();	
	}
	
	if (!$part = VBSIGNATURES::$cache['part'][$vbulletin->GPC['partid']])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'noexists',
		));
		die();	
	}
	
	if (!$part['active'])
	{
		// Inactive type
		echo LIVEWALL::encodeJSON(array(
			'error' => 'noexists',
		));
		die();	
	}
	
	if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, $part['permissions'], 'default'))
	{
		// This item isn't to be displayed
		echo LIVEWALL::encodeJSON(array(
			'error' => 'nopermissions',
		));
		die();	
	}
	
	if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, VBSIGNATURES::$cache['signaturestyle'][$signaturestyle['signaturestyleid']]['permissions'], 'default'))
	{
		// This style isn't to be displayed
		echo LIVEWALL::encodeJSON(array(
			'error' => 'nopermissions',
		));
		die();	
	}
	
	if (!VBSIGNATURES::checkPermissions($vbulletin->userinfo, VBSIGNATURES::$cache['category'][$part['categoryid']]['permissions'], 'default'))
	{
		// This category isn't to be displayed
		echo LIVEWALL::encodeJSON(array(
			'error' => 'nopermissions',
		));
		die();	
	}
	
	if ($part['price'] > $vbulletin->userinfo['dbtech_vbsignatures_points'])
	{
		echo LIVEWALL::encodeJSON(array(
			'error' => 'nofunds',
		));
		die();	
	}	
	
	// Grab our inventory
	if ($inventory = VBSIGNATURES::$db->fetchOne('SELECT * FROM $dbtech_vbsignatures_inventory WHERE userid = ? AND partid = ?', array($vbulletin->userinfo['userid'], $part['partid'])))
	{
		// Inactive type
		echo LIVEWALL::encodeJSON(array(
			'error' => 'alreadyowned',
		));
		die();	
	}
	
	// Insert item
	VBSIGNATURES::$db->insert('dbtech_vbsignatures_inventory', array(
		'partid' => $part['partid'],
		'userid' => $vbulletin->userinfo['userid']
	));
	
	// Take away points
	VBSIGNATURES::$db->query('
		UPDATE $' . $vbulletin->options['dbtech_vbsignatures_pointstable'] . '
		SET ' . $vbulletin->options['dbtech_vbsignatures_pointsfield'] . ' = ' . $vbulletin->options['dbtech_vbsignatures_pointsfield'] . ' - ?
		WHERE userid = ?
	', array(
		$part['price'],
		$vbulletin->userinfo['userid']
	));
	
	echo VBSIGNATURES::encodeJSON(array());
	die();	
}

/*======================================================================*\
|| #################################################################### ||
|| # Created: 22:38, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$									 					  # ||
|| #################################################################### ||
\*======================================================================*/
?>